/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json.preferences;

import com.aptana.editor.common.preferences.CommonEditorPreferencePage;
import com.aptana.editor.json.JSONEditor;
import com.aptana.editor.json.JSONPlugin;
import com.aptana.editor.json.preferences.Messages;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class JSONPreferencePage
extends CommonEditorPreferencePage {
    private BooleanFieldEditor foldObjects;
    private BooleanFieldEditor foldArrays;
    private Composite foldingGroup;

    public JSONPreferencePage() {
        this.setDescription(Messages.JSONPreferencePage_JSON_Page_Title);
        this.setPreferenceStore(JSONPlugin.getDefault().getPreferenceStore());
    }

    protected IEclipsePreferences getPluginPreferenceStore() {
        return InstanceScope.INSTANCE.getNode("com.aptana.editor.json");
    }

    protected IPreferenceStore getChainedEditorPreferenceStore() {
        return JSONEditor.getChainedPreferenceStore();
    }

    protected Composite createFoldingOptions(Composite parent) {
        this.foldingGroup = super.createFoldingOptions(parent);
        Label initialFoldLabel = new Label(this.foldingGroup, 64);
        initialFoldLabel.setText(Messages.JSONPreferencePage_initial_fold_options_label);
        this.foldObjects = new BooleanFieldEditor("fold_objects", Messages.JSONPreferencePage_fold_objects_label, this.foldingGroup);
        this.addField((FieldEditor)this.foldObjects);
        this.foldArrays = new BooleanFieldEditor("fold_arrays", Messages.JSONPreferencePage_fold_arrays_label, this.foldingGroup);
        this.addField((FieldEditor)this.foldArrays);
        return this.foldingGroup;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.enableFolding) {
            Object newValue = event.getNewValue();
            if (Boolean.TRUE == newValue) {
                this.foldObjects.setEnabled(true, this.foldingGroup);
                this.foldArrays.setEnabled(true, this.foldingGroup);
            } else {
                this.foldObjects.setEnabled(false, this.foldingGroup);
                this.foldArrays.setEnabled(false, this.foldingGroup);
            }
        }
        super.propertyChange(event);
    }
}

